using System;
using System.Collections.Generic;
using System.Text;

namespace Intemi.InTrees.Implements
{
    public class CommitteeSC : IStoppingCriterion
    {
        public static byte OP_OR = 0;
        public static byte OP_AND = 1;

        private NaturalStoppingCriterium naturalSC = new NaturalStoppingCriterium();
        private List<IStoppingCriterion> criteriums;
        private byte op;

        public CommitteeSC(List<IStoppingCriterion> criteriums, byte op)
        {
            this.criteriums = criteriums;
            this.op = op;
        }

        public bool Stop(IDataTable dataTable, ref bool shouldTerminate)
        {
            bool stop = naturalSC.Stop(dataTable, ref shouldTerminate);
            if (!stop)
            {
                if (op == CommitteeSC.OP_OR)
                {
                    foreach (IStoppingCriterion sc in criteriums)
                    {
                        stop = sc.Stop(dataTable, ref shouldTerminate);
                        if (stop)
                            break;
                    }
                }
                else if (op == CommitteeSC.OP_AND)
                {
                    foreach (IStoppingCriterion sc in criteriums)
                    {
                        stop = sc.Stop(dataTable, ref shouldTerminate);
                        if (!stop)
                            break;
                    }
                }
            }
            return (stop);
        }

        public bool Stop(IDataTable dataTable, List<INodeTest> nodeTests, ref bool shouldTerminate)
        {
            bool stop = naturalSC.Stop(dataTable, nodeTests, ref shouldTerminate);
            if (!stop)
            {
                if (op == CommitteeSC.OP_OR)
                {
                    foreach (IStoppingCriterion sc in criteriums)
                    {
                        stop = sc.Stop(dataTable, nodeTests, ref shouldTerminate);
                        if (stop)
                            break;
                    }
                }
                else if (op == CommitteeSC.OP_AND)
                {
                    foreach (IStoppingCriterion sc in criteriums)
                    {
                        stop = sc.Stop(dataTable, nodeTests, ref shouldTerminate);
                        if (!stop)
                            break;
                    }
                }
            }
            return (stop);
        }
    }
}
